<?php
/**
 * Aliases for special pages
 *
 * @file
 * @ingroup Extensions
 */

$specialPageAliases = [];

/** English (English) */
$specialPageAliases['en'] = [
	'GlobalUsage' => [ 'GlobalUsage' ],
	'MostGloballyLinkedFiles' => [ 'MostGloballyLinkedFiles' ],
	'GloballyWantedFiles' => [ 'GloballyWantedFiles' ],
	'GloballyUnusedFiles' => [ 'GloballyUnusedFiles' ]
];

/** Arabic (العربية) */
$specialPageAliases['ar'] = [
	'GlobalUsage' => [ 'استخدام_عام' ],
	'MostGloballyLinkedFiles' => [ 'أكثر_الملفات_الموصولة_عامة' ],
	'GloballyWantedFiles' => [ 'ملفات_مطلوبة_عامة' ],
];

/** Egyptian Arabic (مصرى) */
$specialPageAliases['arz'] = [
	'GlobalUsage' => [ 'استعمال_عام' ],
];

/** Assamese (অসমীয়া) */
$specialPageAliases['as'] = [
	'GlobalUsage' => [ 'গোলকীয়_ব্যৱহাৰ' ],
];

/** Avaric (авар) */
$specialPageAliases['av'] = [
	'GlobalUsage' => [ 'Глобальное_использование' ],
];

/** Bashkir (башҡортса) */
$specialPageAliases['ba'] = [
	'GlobalUsage' => [ 'GlobalUsage' ],
];

/** Bulgarian (български) */
$specialPageAliases['bg'] = [
	'GlobalUsage' => [ 'Глобално_използване_на_файл' ],
];

/** Western Balochi (بلوچی رخشانی) */
$specialPageAliases['bgn'] = [
	'GlobalUsage' => [ 'سراسرین_ایستیپاده' ],
	'MostGloballyLinkedFiles' => [ 'بازتیرین_سراسرین_لینک_بوته_ئین_پایلان' ],
	'GloballyWantedFiles' => [ 'زَرورتین_سراسرین_پایلان' ],
];

/** Banjar (Bahasa Banjar) */
$specialPageAliases['bjn'] = [
	'GlobalUsage' => [ 'Pamakaian_global' ],
];

/** Bengali (বাংলা) */
$specialPageAliases['bn'] = [
	'GlobalUsage' => [ 'বৈশ্বিক_ব্যবহার' ],
	'MostGloballyLinkedFiles' => [ 'বৈশ্বিকভাবে_সর্বাধিক_সংযুক্ত_ফাইল' ],
	'GloballyWantedFiles' => [ 'বৈশ্বিকভাবে_আবশ্যিক_ফাইল' ],
];

/** Breton (brezhoneg) */
$specialPageAliases['br'] = [
	'GlobalUsage' => [ 'ImplijHollek' ],
];

/** Bosnian (bosanski) */
$specialPageAliases['bs'] = [
	'GlobalUsage' => [ 'GlobalnaUpotreba' ],
];

/** Min Dong Chinese (Mìng-dĕ̤ng-ngṳ̄) */
$specialPageAliases['cdo'] = [
	'GlobalUsage' => [ '全局使法' ],
];

/** Chechen (нохчийн) */
$specialPageAliases['ce'] = [
	'GlobalUsage' => [ 'Глобальни_лелор' ],
];

/** German (Deutsch) */
$specialPageAliases['de'] = [
	'GlobalUsage' => [ 'Globale_Benutzung', 'Globale_Verwendung' ],
	'MostGloballyLinkedFiles' => [ 'Am_meisten_global_verlinkte_Dateien' ],
	'GloballyWantedFiles' => [ 'Global_gewünschte_Dateien' ],
];

/** Zazaki (Zazaki) */
$specialPageAliases['diq'] = [
	'GlobalUsage' => [ 'GlobalKarkerdış' ],
];

/** Lower Sorbian (dolnoserbski) */
$specialPageAliases['dsb'] = [
	'GlobalUsage' => [ 'Globalne_wužywanje' ],
];

/** Greek (Ελληνικά) */
$specialPageAliases['el'] = [
	'GlobalUsage' => [ 'ΚαθολικήΧρήση' ],
];

/** Spanish (español) */
$specialPageAliases['es'] = [
	'GlobalUsage' => [ 'Uso_global', 'UsoGlobal' ],
];

/** Estonian (eesti) */
$specialPageAliases['et'] = [
	'GlobalUsage' => [ 'Globaalne_kasutus' ],
];

/** Persian (فارسی) */
$specialPageAliases['fa'] = [
	'GlobalUsage' => [ 'استفادهٔ_سراسری' ],
	'MostGloballyLinkedFiles' => [ 'بیشترین_پرونده‌های_پیونده‌شدهٔ_سراسری' ],
	'GloballyWantedFiles' => [ 'پرونده‌های_سراسری_مورد_نیاز' ],
];

/** French (français) */
$specialPageAliases['fr'] = [
	'GlobalUsage' => [ 'Usage_global', 'UsageGlobal' ],
];

/** Arpitan (arpetan) */
$specialPageAliases['frp'] = [
	'GlobalUsage' => [ 'Usâjo_globâl', 'UsâjoGlobâl' ],
];

/** Galician (galego) */
$specialPageAliases['gl'] = [
	'GlobalUsage' => [ 'Uso_global' ],
];

/** Swiss German (Alemannisch) */
$specialPageAliases['gsw'] = [
	'GlobalUsage' => [ 'Wältwyti_Benutzig' ],
];

/** Gujarati (ગુજરાતી) */
$specialPageAliases['gu'] = [
	'GlobalUsage' => [ 'વૈશ્વિક_વપરાશ' ],
];

/** Hebrew (עברית) */
$specialPageAliases['he'] = [
	'GlobalUsage' => [ 'שימוש_גלובלי_בקובץ', 'שימוש_גלובלי_בקבצים' ],
	'MostGloballyLinkedFiles' => [ 'הקבצים_המקושרים_ביותר_גלובלית' ],
	'GloballyWantedFiles' => [ 'הקבצים_המבוקשים_ביותר_גלובלית' ],
];

/** Hindi (हिन्दी) */
$specialPageAliases['hi'] = [
	'GlobalUsage' => [ 'वैश्विक_प्रयोग' ],
];

/** Croatian (hrvatski) */
$specialPageAliases['hr'] = [
	'GlobalUsage' => [ 'Globalna_uporaba' ],
];

/** Upper Sorbian (hornjoserbsce) */
$specialPageAliases['hsb'] = [
	'GlobalUsage' => [ 'Globalne_wužiwanje' ],
];

/** Haitian (Kreyòl ayisyen) */
$specialPageAliases['ht'] = [
	'GlobalUsage' => [ 'ItilizasyonGlobal' ],
];

/** Hungarian (magyar) */
$specialPageAliases['hu'] = [
	'GlobalUsage' => [ 'Globális_fájlhasználat' ],
];

/** Interlingua (interlingua) */
$specialPageAliases['ia'] = [
	'GlobalUsage' => [ 'Uso_global' ],
];

/** Indonesian (Bahasa Indonesia) */
$specialPageAliases['id'] = [
	'GlobalUsage' => [ 'Penggunaan_global', 'PenggunaanGlobal' ],
];

/** Igbo (Igbo) */
$specialPageAliases['ig'] = [
	'GlobalUsage' => [ 'Ọdí_na_ùwù_nílé' ],
];

/** Italian (italiano) */
$specialPageAliases['it'] = [
	'GlobalUsage' => [ 'UsoGlobale', 'UsoGlobaleFile' ],
];

/** Japanese (日本語) */
$specialPageAliases['ja'] = [
	'GlobalUsage' => [ 'グローバルなファイル使用状況', 'グローバル使用状況' ],
];

/** Georgian (ქართული) */
$specialPageAliases['ka'] = [
	'GlobalUsage' => [ 'გლობალური_გამოყენება' ],
];

/** Khmer (ភាសាខ្មែរ) */
$specialPageAliases['km'] = [
	'GlobalUsage' => [ 'បម្រើបម្រាស់ជាសាកល' ],
];

/** Korean (한국어) */
$specialPageAliases['ko'] = [
	'GlobalUsage' => [ '전역사용' ],
	'MostGloballyLinkedFiles' => [ '가장전역으로링크된파일' ],
	'GloballyWantedFiles' => [ '전역으로필요한파일' ],
];

/** Cornish (kernowek) */
$specialPageAliases['kw'] = [
	'GlobalUsage' => [ 'DevnydhOllvysel' ],
];

/** Ladino (Ladino) */
$specialPageAliases['lad'] = [
	'GlobalUsage' => [ 'UsoGlobbal' ],
];

/** Luxembourgish (Lëtzebuergesch) */
$specialPageAliases['lb'] = [
	'GlobalUsage' => [ 'Globale_Gebrauch' ],
	'MostGloballyLinkedFiles' => [ 'Fichieren_déi_global_am_dackste_verlinkt_sinn' ],
	'GloballyWantedFiles' => [ 'Global_gewënscht_Fichieren' ],
];

/** Macedonian (македонски) */
$specialPageAliases['mk'] = [
	'GlobalUsage' => [ 'ГлобалноКористење' ],
	'MostGloballyLinkedFiles' => [ 'ГлобалноНајупотребуваниПодатотеки' ],
	'GloballyWantedFiles' => [ 'ГлобалноПотребниПодатотеки' ],
];

/** Malayalam (മലയാളം) */
$specialPageAliases['ml'] = [
	'GlobalUsage' => [ 'ആഗോള‌ഉപയോഗം' ],
];

/** Marathi (मराठी) */
$specialPageAliases['mr'] = [
	'GlobalUsage' => [ 'वैश्विकउपयोग' ],
];

/** Maltese (Malti) */
$specialPageAliases['mt'] = [
	'GlobalUsage' => [ 'UżuGlobali' ],
];

/** Norwegian Bokmål (norsk bokmål) */
$specialPageAliases['nb'] = [
	'GlobalUsage' => [ 'Global_bruk' ],
];

/** Low Saxon (Netherlands) (Nedersaksies) */
$specialPageAliases['nds-nl'] = [
	'GlobalUsage' => [ 'Globaal_gebruuk' ],
];

/** Dutch (Nederlands) */
$specialPageAliases['nl'] = [
	'GlobalUsage' => [ 'GlobaalGebruik' ],
	'MostGloballyLinkedFiles' => [ 'GlobaalMeestGebruikteBestanden' ],
	'GloballyWantedFiles' => [ 'GlobaalGewensteBestanden' ],
];

/** Norwegian Nynorsk (norsk nynorsk) */
$specialPageAliases['nn'] = [
	'GlobalUsage' => [ 'Global_bruk' ],
];

/** Occitan (occitan) */
$specialPageAliases['oc'] = [
	'GlobalUsage' => [ 'Usatge_global', 'UsatgeGlobal' ],
];

/** Polish (polski) */
$specialPageAliases['pl'] = [
	'GlobalUsage' => [ 'Globalne_wykorzystanie' ],
];

/** Portuguese (português) */
$specialPageAliases['pt'] = [
	'GlobalUsage' => [ 'Utilização_global' ],
];

/** Romanian (română) */
$specialPageAliases['ro'] = [
	'GlobalUsage' => [ 'Utilizare_globală' ],
];

/** Russian (русский) */
$specialPageAliases['ru'] = [
	'GlobalUsage' => [ 'Глобальное_использование' ],
];

/** Sanskrit (संस्कृतम्) */
$specialPageAliases['sa'] = [
	'GlobalUsage' => [ 'वैश्विकउपयोग' ],
];

/** Sicilian (sicilianu) */
$specialPageAliases['scn'] = [
	'GlobalUsage' => [ 'UsoGlobale', 'UsoGlobaleFile' ],
];

/** Slovak (slovenčina) */
$specialPageAliases['sk'] = [
	'GlobalUsage' => [ 'GlobálneVyužitie' ],
];

/** Swedish (svenska) */
$specialPageAliases['sv'] = [
	'GlobalUsage' => [ 'Global_användning' ],
	'MostGloballyLinkedFiles' => [ 'Mest_globalt_länkade_filer' ],
	'GloballyWantedFiles' => [ 'Globalt_önskade_filer' ],
];

/** Tagalog (Tagalog) */
$specialPageAliases['tl'] = [
	'GlobalUsage' => [ 'Pandaigdigang_paggamit' ],
];

/** Turkish (Türkçe) */
$specialPageAliases['tr'] = [
	'GlobalUsage' => [ 'KüreselKullanım' ],
];

/** Ukrainian (українська) */
$specialPageAliases['uk'] = [
	'GlobalUsage' => [ 'Глобальне_використання', 'Глобальное_использование' ],
];

/** Urdu (اردو) */
$specialPageAliases['ur'] = [
	'GlobalUsage' => [ 'عالمی_استعمال' ],
	'MostGloballyLinkedFiles' => [ 'بیشتر_عالمی_مربوط_فائلیں' ],
	'GloballyWantedFiles' => [ 'عالمی_مطلوب_فائلیں' ],
];

/** Venetian (vèneto) */
$specialPageAliases['vec'] = [
	'GlobalUsage' => [ 'UtilizoGlobal' ],
];

/** Vietnamese (Tiếng Việt) */
$specialPageAliases['vi'] = [
	'GlobalUsage' => [ 'Sử_dụng_toàn_cục' ],
	'MostGloballyLinkedFiles' => [ 'Tập_tin_liên_kết_nhiều_nhất_toàn_cục' ],
	'GloballyWantedFiles' => [ 'Tập_tin_cần_thiết_toàn_cục' ],
];

/** Cantonese (粵語) */
$specialPageAliases['yue'] = [
	'GlobalUsage' => [ '全域使用' ],
];

/** Simplified Chinese (中文（简体）‎) */
$specialPageAliases['zh-hans'] = [
	'GlobalUsage' => [ '全域使用情况' ],
	'MostGloballyLinkedFiles' => [ '全域最多链接文件' ],
	'GloballyWantedFiles' => [ '全域需要的文件' ],
];

/** Traditional Chinese (中文（繁體）‎) */
$specialPageAliases['zh-hant'] = [
	'GlobalUsage' => [ '全域使用狀況' ],
	'MostGloballyLinkedFiles' => [ '全域最多連接檔案' ],
	'GloballyWantedFiles' => [ '全域需要的檔案' ],
];
